<?php
/**
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.html.html');
jimport('joomla.form.formfield');
jimport('joomla.form.helper');


class JFormFieldK2Categories extends JFormField{


	public $type = 'k2categories';

	protected function getInput()
	{
		$attr = '';

		// Initialize some field attributes.
		$attr .= $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';

		// To avoid user's confusion, readonly="true" should imply disabled="true".
		if ( (string) $this->element['readonly'] == 'true' || (string) $this->element['disabled'] == 'true') {
			$attr .= ' disabled="disabled"';
		}

		$attr .= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		$attr .= $this->multiple ? ' multiple="multiple"' : '';

		// Initialize JavaScript field attributes.
		$attr .= $this->element['onchange'] ? ' onchange="'.(string) $this->element['onchange'].'"' : '';
		
		
		$db = &JFactory::getDBO();
		$tables = $db->getTableList();
		$k2installed = false;
		foreach($tables as $table)
		{
			$pos = stripos($table,'k2_categories');
			if($pos !== false)
			{
				$k2installed = true;
			}
		}
		if(!$k2installed){return '';}
		$query = $db->getQuery(true);
		$query->select('id, name as title');
		$query->from('#__k2_categories');
		$query->where('published=1 AND trash=0');
        $query->order('parent, ordering');		
		$db->setQuery( $query );
		
		if(!$mitems = $db->loadObjectList())
		{
			return JTEXT::_('K2NOCATEGORIES');
		}
		if(count($mitems) == 0)
		{
			return JTEXT::_('K2NOCATEGORIES');
		}
		
		
		$mitem = new stdClass();
		$mitem->id = '';
		$mitem->title = JText::_("ALLCATEGORIES");
				 
        array_unshift($mitems, $mitem);
		
		return JHTML::_('select.genericlist',  $mitems, $this->name, trim($attr), 'id', 'title', $this->value );
		
		
	}
}
