var ModuloMap = {};

ModuloMap.init = function() {
	$('#inputRechercheRue').val('');
	ModuloMap.myPos = new Array();

	var lat = 43.6;
	var lng = 3.8833;

	ModuloMap.myPos['lat'] = lat;
	ModuloMap.myPos['lng'] = lng;

	ModuloMap.macarte = new L.Map('macarte', { zoomControl: true });
    //proxy cache OSM
    var Url = 'http://a.tiles.mapbox.com/v3/autour.i21ika1b/{z}/{x}/{y}.png';
	// Attributions OSM
	var osmAttrib = 'Map data © OpenStreetMap contributors - Développé par <a href="http://autour.com" target="_blank">Autour.com</a>';
	// Paramétrage de la carte : theme, zoom, attributions OSM...
	
	var osm = new L.TileLayer(Url, {
		minZoom: 13,
		maxZoom: 16,
		attribution: osmAttrib
	});
	// Centrage de la carte sur la derniere lat long en session du user
	ModuloMap.macarte.setView(new L.LatLng(lat, lng), 13);
	ModuloMap.macarte.addLayer(osm);
	
	// Initialisation des fichiers Json
	ModuloMap.initJsonFile('34000');

	$(document).on('click','.post', function(e){
		$.ajax({
	        url: 'envoiStation.php',
	        type: 'post',
	        data: {
	        		nom : $('.nom').val(),
	        		email : $('.email').val(),
	        		tel : $('.tel').val(),
	        		latlng : $('.latlng').val(),
	        		url : $('.url').val()
	        	  },
	        success: function(){
	        	$('.formulaire').addClass('hide');
	        	$('.retourFormulaire').fadeIn('slow');
	            $('.nom').val(''); 
	            $('.email').val(''); 
	            $('.tel').val('');
				$('.latlng').val('');
	        },
	        error:function(){
	         // Gestion de l'erreur  
	        }
	    }); 
	});

	
	$(document).on('click','.post2', function(e){
		$.ajax({
	        url: 'envoiStation2.php',
	        type: 'post',
	        data: {
	        		nom : $('.nom').val(),
	        		email : $('.email').val(),
	        		tel : $('.tel').val(),
	        		latlng : $('.latlng').val(),
	        		url : $('.url').val()
	        	  },
	        success: function(){
	        	$('.formulaire2').addClass('hide');
	        	$('.retourFormulaire2').fadeIn('slow');
	            $('.nom').val(''); 
	            $('.email').val(''); 
	            $('.tel').val('');
				$('.latlng').val('');
	        },
	        error:function(){
	         // Gestion de l'erreur  
	        }
	    }); 
	});


	$('#inputRechercheRue').keyup( function() {
		ModuloMap.searchStreet();
	});

	$(document).on('click', '#inputRechercheRue', function(e){
		$('#infosStation .closeWindow').trigger("click");
		$('.stationModulauto').removeClass('hide');
	});
	

	ModuloMap.macarte.on('click', function(e){
		// Récupération du nom de la rue apres chaque evenement dragend
		$('#infosStation .closeWindow').trigger("click");
	});

	$('#propositionForm .closeWindow').click(function(e){
		$('#propositionForm').addClass('hide');
	})

	// Masquer le pointeur et le cercle de la joie
	$('.masquer').click(function(e){
		ModuloMap.removeGeoloc();
	})

	// Gestion des onglets pour les villes
	$('#villeNav li a').click(function(e){

		// Reinit toggle Essence si actif
		if (!$('.img2').hasClass('hide')){
			$('.btE').trigger('click');
			$('.img1').removeClass('hide');
			$('.img2').addClass('hide');
		}
		

		if( !$(this).parent().hasClass('active') 
			&& !$(this).parent().hasClass('dropdown')
			&& $(this).parent().parent().hasClass('popupVille') ){
			var ville = $(this).data().ville;
			var lat, lng;
			

			$('#villeNav li.active').removeClass('active');
			$(this).parent().addClass('active');
			$('#carteForm').addClass('hide');

			switch (ville) {
				case 34000 :
					 lat = 43.6110142713691;
					 lng = 3.87675889323906;
					 $('#carteForm').removeClass('hide');
					 break;

				case 30000 :
					 lat = 43.8373308499382;
					 lng = 4.36016993085138;
					 break;

				case 66000 :
					 lat = 42.697955767557;
					 lng = 2.89517203492303;
					 break;

				case 11000 :
					 var lat = 43.1845266415262;
					 var lng = 3.00368758787902;
					 break;
			}
			
			// On supprime la geoloc
			ModuloMap.removeGeoloc();
			// On deplace la carte vers la nouvelle ville
			ModuloMap.latLng = new L.LatLng(lat,lng);	
			// Repositionnement de la carte
			ModuloMap.macarte.setView(ModuloMap.latLng, 13);
			// On affiche les elements en fonctions de la ville
			ModuloMap.stationOnMap(ville);
			ModuloMap.essenceOnMap(ville);
			ModuloMap.listeVoitures(ville);

			$('#infosStation').addClass('hide');
		}
	});
	$('#villeSelect li a').click(function(){
		$('.clicVille').html('');
		$('.dispo').attr('href','#');
		var url = $(this).data().lien;
		var ville = $(this).text();
		$('.clicVille').html(ville);
		$('.dispo').attr('href',url);
		$('#myModal').modal('show')
	});

};

ModuloMap.removeGeoloc = function () {
	if (ModuloMap.myPosition != undefined){
		// On supprime la position
		ModuloMap.macarte.removeLayer(ModuloMap.myPosition);
		// On supprime le cercle
		ModuloMap.macarte.removeLayer(ModuloMap.currentDiameter);
		// On hide le curseur reglable et on reinit le champ de recherche
		$('.sliderDistance').addClass('hide');
		$('#inputRechercheRue').val('');
		$('.geolocLabel').addClass('hide');
	}
};

ModuloMap.setCurrentDiameter = function (lat, lng, distance) {
	ModuloMap.currentDiameter = L.circle([lat, lng], distance*2, {
		opacity : 1, fillOpacity : 0.2, weight : 2, color : "#F68620"
	});
	// Affichage du cercle
	ModuloMap.currentDiameter.addTo(ModuloMap.macarte);
};

ModuloMap.initJsonFile = function (ville) {
	$.getJSON( "json/station.json", function( data ) {
		ModuloMap.stationsModulauto = data;
		// Initialisation des stations Modulauto
		ModuloMap.stationOnMap(ville);
	});
	$.getJSON( "json/essence.json", function( data ) {
		ModuloMap.stationsEssences = data;
		// Initialisation des stations essences
		ModuloMap.essenceOnMap(ville);
	});
	$.getJSON( "json/voitureParVille.json", function( data ) {
		ModuloMap.voitureParVille = data;
		$.getJSON( "json/voitures.json", function( data ) {
			ModuloMap.voitures = data;
			// Initialisation de la liste de voitures
			ModuloMap.listeVoitures(ville);
		});	
	});
}

ModuloMap.stationOnMap = function (ville) {
	var siegeAuto = false;
	$.each( ModuloMap.stationsModulauto, function( key, val ) {
		if(val.ville == ville){
			var station = 'station'+key;
			var iconImage = 'integration/station.png';
			var classIcon = 'stationModulauto';

			if ( val.voitures != undefined){
				$.each( val.voitures, function( k, v ) {
					classIcon += ' voiture-'+v;
				});
			}

			if ( val.siege == true){
				classIcon += ' siegeAuto';
				if(!siegeAuto) siegeAuto = true;
			}

			if (val.actif == false) {
				iconImage = 'integration/station-inactive.png';
				classIcon += ' inactive';
			}

			var moduloIcon = L.icon({
				iconUrl:iconImage, 
				iconSize:[28, 28],
				iconAnchor:[14, 14],
				className:classIcon
			});

			ModuloMap[station] = new L.marker([val.latitude, val.longitude],
				{ icon : moduloIcon,draggable : false} );

			ModuloMap[station]
				.addTo(ModuloMap.macarte)
				.bindPopup(val.nom, { offset:[0, -10],closeButton: false });

			ModuloMap[station].addEventListener('click', function(e){
				$('.headerInfos').empty();
				$('.contentInfos').empty();
				ModuloMap.descriptionStation(val.latitude,val.longitude);
			});

			ModuloMap[station].addEventListener('mouseover', function(e){
				ModuloMap[station].openPopup();
			});

			ModuloMap[station].addEventListener('mouseout', function(e){
				ModuloMap[station].closePopup();
			});
		}
	});
	if(siegeAuto){
		$('.btnSiegeAuto').show()
	} else {
		$('.btnSiegeAuto').hide();
	}
};

ModuloMap.descriptionStation = function (lat,lng) {
	$.each( ModuloMap.stationsModulauto, function( key, val ) {
					
		if(val.latitude == lat && val.longitude == lng) {

			$('.headerInfos').html('<h4>' + val.nom + '</h4>');
			
			var infos = '';
			$.each( val.informations, function( key, val ) {

				infos+='<p>' + val + '</p>';
			});
			$('.contentInfos').html(infos);
		}			

	});

	$('.contentInfos').slimScroll({
        width: '300px',
	    height: '250px',
	    size: '15px',
	    position: 'right',
	    distance: '10px',
	    color: '#f68620',
	    alwaysVisible: true,
	    start: 'top',
	    railVisible: true,
	    railColor: '#fffff',
	    railOpacity: 1,
	    wheelStep: 10,
	    allowPageScroll: true,
	    disableFadeOut: false
    });

	$('#infosStation').removeClass('hide');
};

ModuloMap.essenceOnMap = function (ville) {
	essenceLayer = L.layerGroup();
	var matchVille = false;
	$.each( ModuloMap.stationsEssences, function( key, val ) {
		if(val.ville == ville){
			var essence = 'essance'+key;
			var essenceIcon = L.icon({
				iconUrl:'integration/station-service.png', 
				iconSize:[32, 32],
				iconAnchor:[16, 16],
				className:'stationEssence hide'
			});

			ModuloMap[essence] = new L.marker([val.latitude, val.longitude],
				{ icon : essenceIcon,draggable : false} );

			ModuloMap[essence]
				.bindPopup(val.nom, { offset:[0, -10],closeButton: false });

			ModuloMap[essence].addEventListener('mouseover', function(e){
				ModuloMap[essence].openPopup();
			});

			ModuloMap[essence].addEventListener('mouseout', function(e){
				ModuloMap[essence].closePopup();
			});

			essenceLayer.addLayer(ModuloMap[essence]);
			if(!matchVille) matchVille = true;
		}
	});

	if(matchVille){
		essenceLayer.addTo(ModuloMap.macarte);
		$('.btnStationService').show()
	} else {
		$('.btnStationService').hide();
	}
};

ModuloMap.listeVoitures = function(ville) {
	// Je stocke mon tableau de voiture contenu dans cette ville
	var voitures = new Array;
	$.each( ModuloMap.voitureParVille, function( key, val ) {
		if(val.ville == ville) voitures = val.voitures;
	});

	if(voitures.length > 0){
		var infosVoiture = '<ul class="nav nav-pills nav-stacked listeVoiture pull-right">';
		$.each( ModuloMap.voitures, function( key, val ) {
			if(voitures.indexOf(val.id) > -1){
				var voitureOpt = '';
				$.each( val.options.option, function( key, val ) {
						voitureOpt += '<li>' + val + '</li>';
				});
				infosVoiture += '<li class="infosVoiture">'
							+ '<div class="dropdown">'
								+'<a href="#" class="btnVoiture dropdown-toggle" data-toggle="dropdown" data-id="'+val.id+'">'
									+'<img src="integration/voiture'+val.id+'.png" alt="voiture '+val.id+'" height="37" width="90"/>'
									+'<img src="integration/voiture'+val.id+'-survol.png" alt="voiture '+val.id+' survol" height="37" width="90" class="hide"/>'
								+'</a>'
								+'<ul class="dropdown-menu">'
									+'<li class="descVoiture">'
										+'<h5>' + val.nom + '</h5>'
										+'<p>' + val.categorie + '</p>'
										+'<ul>'
										+voitureOpt
										+'</ul>'
									+'</li>'
								+'</ul>'
							+'</div>'
						+'</li>'
			}
		});
		infosVoiture += '</ul>';
		$('#filtresParVoitures').html(infosVoiture);
	}
}

ModuloMap.setMarker = function(LatLng) {
	// Positionnement de marker & cercle avec le nouveau LatLng
	ModuloMap.myPosition.setLatLng(LatLng);
}

ModuloMap.searchStreet = function() {
	var funct;
	//Séléction du champ de recherche
	var search = $("#inputRechercheRue");
	var spinnerLabel = $(".rechercheRue .spinnerLabel");
	var geolocLabel = $(".rechercheRue .geolocLabel");
	try {	
		//Activation de l'autocomplete
		search.typeahead({
			//Requete de recherche
			source: function(query, process) { 
			// Temporisation des requetes au serveur
			if (typeof(funct) !== 'undefined'){ 
	       		clearTimeout(funct); 
	    	}
 			funct = setTimeout(function () { 		
	 			spinnerLabel.removeClass('hide');
	 			geolocLabel.addClass('hide');
	 			ModuloMap.geoDataUpdated = false;
				$.jsonp({
					"url": "http://geoloc-modulauto.autour-geo.cc/adresse/get-rue-fragment?callback=?",
					"contentType": "application/javascript",
					"dataType": "jsonp",    
					"data": {
						"term": search.val(),
						"filter": 34172
					},
					"success": function(rData) {
						if (rData.length == 0) {
							results = {};
							labels = [];

							spinnerLabel.addClass('hide');

							//Ajout des résultat à la liste pour l'autocomplete
							process(labels);
						} 
						else {
							//Tableau pour ajouter les resultats trouvés
							results = {};
							labels = [];
							// Parcours des résultats
							for (var i = 0; i < rData.length; i++) {
							// Ajout de toutes les informations des rues
								results[rData[i].value] = rData[i];
							// Ajout des noms des rues pour l'autocomplete
								labels.push(rData[i].value);
							}

							spinnerLabel.addClass('hide');

							//Ajout des résultat à la liste pour l'autocomplete
							process(labels);
						}
					},
					"error": function(d, mg) {

					}
				});
			
			  },500); // Fin tempo 1/2 secondes arret frappe

			},
			// options de filtrage 
			items: 5,
			minLength: 3,
			matcher: function(item) {
				search.focus();
				return true;
			}, highlighter: function (item) {
				var town = results[item].commune.toLowerCase();
				item += ', ' + town.charAt(0).toUpperCase() + town.slice(1);
		      	var query = this.query.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, '\\$&')
		      	return item.replace(new RegExp('(' + query + ')', 'ig'), function ($1, match) {
		        	return '<strong>' + match + '</strong>'
		      })
		    },

			// Interprétation de l'element séléctionné
			updater: function(item) {
				// On enlève le focus 
				search.blur();

				search.val(item);
				// Récupération de la position
				ModuloMap.latLng = new L.LatLng(results[item].latitude,
					results[item].longitude);	
				// Repositionnement de la carte

				ModuloMap.macarte.setView(ModuloMap.latLng, 15);
				// On remplit le tableau avec les nouvelles donnees

				ModuloMap.geoDataUpdated = true;
				if (ModuloMap.myPosition != undefined){
					ModuloMap.macarte.removeLayer(ModuloMap.myPosition);
					ModuloMap.macarte.removeLayer(ModuloMap.currentDiameter);
				}
				

				// Ajout du marker
				var iconGeoloc = L.icon({
				iconUrl:'integration/icn-geoloc.png', 
				iconSize:[26, 40],
				iconAnchor:[13, 40],
				className:'myPosition'
						});
				
				ModuloMap.myPosition = new L.marker([results[item].latitude, results[item].longitude],
					{ icon : iconGeoloc,draggable : true} );

				ModuloMap.myPosition.addTo(ModuloMap.macarte);
				ModuloMap.setCurrentDiameter(results[item].latitude,
					results[item].longitude,300);

				// On lance la recherche de station à 300m
				// Requete Json recherche si station à moins de 300 mètres
				ModuloMap.searchStationM300(ModuloMap.latLng);
				
				// Ajout ecouteur
				ModuloMap.myPosition.addEventListener('dragstart', function(e){
				// On bouge le curseur on supprime le cercle
				ModuloMap.macarte.removeLayer(ModuloMap.currentDiameter);
				});

				ModuloMap.myPosition.addEventListener('dragend', function(e){
				// On stocke la nouvelle lat long du pointeur
				var newPos = this.getLatLng();
				ModuloMap.macarte.panTo(newPos);
				ModuloMap.myPos['lat'] = newPos.lat;
				ModuloMap.myPos['lng'] = newPos.lng;
				// On affiche à nouveau le cercle avec le diametre selectionné
				ModuloMap.setCurrentDiameter(ModuloMap.myPos['lat'],
											 ModuloMap.myPos['lng'],
											 ModuloMap.currentDiameter._mRadius / 2);
				ModuloMap.currentDiameter.addTo(ModuloMap.macarte);
				// Requete Json recherche si station à moins de 300 mètres
				ModuloMap.searchStationM300(newPos);
				});


				ModuloMap.myPos['lat'] = results[item].latitude;
				ModuloMap.myPos['lng'] = results[item].longitude;

				geolocLabel.removeClass('hide');
				$('.myPosition').removeClass('hide');
				$('#infosStation').addClass('hide');
				
				return item;
			}
		});
			
	} catch (e) {
		alert(e);
	}	

}

ModuloMap.searchStationM300 = function(latlng) {
	// Recherche dans station si position -300m MyPosition
	var i = 0;
	$.each( ModuloMap.stationsModulauto, function( key, val ) {
			var stationLatLng = L.latLng(val.latitude,val.longitude);
			var mapDistance = stationLatLng.distanceTo(latlng)/2;
			if (mapDistance <= 300) { i++; }
	});
	if (i == 0) {
		ModuloMap.myPosition.bindPopup('<div><span style="font-size: 14px;'+
				'font-weight:bold" >Aucune station à moins de 300 mètres de vous. '+
				'Souhaitez vous proposer une station à cet endroit là ?</span><br>'+
				'<span style="font-size: 14px;" >Déplacer manuellement le pointeur pour suggérer une station</span></div>'+
				'<div class="text-right"><a href="#" class="btn AtagStation">Annuler</a>'+
				'&nbsp;&nbsp;<a href="#" class="btn btn-modulauto tagStation">Valider</a></div>'
			 	, { offset:[-2, -25],closeButton: false }).openPopup();
		// On recupere la lat,long et on charge le formulaire php ....
		$('.tagStation').click(function(){
			ModuloMap.myPosition.closePopup();
			$('#propositionForm').removeClass('hide');
			$('.formulaire').removeClass('hide');
	        $('.retourFormulaire').css('display','none');	
			// On remplit le formulaire Html - Champ hidden latlng
			$('.latlng').val(ModuloMap.myPosition.getLatLng());
		});

		$('.AtagStation').click(function(){
			ModuloMap.myPosition.closePopup();
		});
	} else {
		// Si au moins 1 station
		if (i == 1){
			var stat = 'station';
		} else {
			var stat = 'stations';
		}
		ModuloMap.myPosition.bindPopup('<div><span style="font-size: 14px;'+
				'font-weight:bold" >'+
				'Il y a '+ i +' '+ stat +' à moins de 300 mètres, Modulauto est fait pour vous.'+
				'<br>En savoir plus sur nos différentes formules ?</span></div>'+
				'<div class="text-right"><a href="#" class="btn AtagStation">Annuler</a>'+
				'&nbsp;&nbsp;<a href="#" class="btn btn-modulauto tagStation">Valider</a></div>'
			 	, { offset:[-2, -25],closeButton: false }).openPopup();
		// On recupere la lat,long et on charge le formulaire php ....
		$('.tagStation').click(function(){
			ModuloMap.myPosition.closePopup();
			$('#propositionForm2').removeClass('hide');
			$('.formulaire2').removeClass('hide');
	        $('.retourFormulaire2').css('display','none');	
			// On remplit le formulaire Html - Champ hidden latlng
			$('.latlng').val(ModuloMap.myPosition.getLatLng());
		});

		$('.AtagStation').click(function(){
			ModuloMap.myPosition.closePopup();
		});


	}
}