$(document).ready(function() {

	ModuloMap.init();

	$('body').on('DOMNodeInserted', '#filtresParVoitures', function(e) {
		initJQueryEventOnCarList();
	});

	$('.closeWindow')
		.click(function() {
			$(this).parent().addClass('hide');
		});

	$('.slider')
		.slider({	
			formater: function(value){
				return value+' m';
			}
		})
		.on('slide', function(e){
			ModuloMap.macarte.removeLayer(ModuloMap.currentDiameter);
			ModuloMap.setCurrentDiameter(ModuloMap.myPos['lat'],ModuloMap.myPos['lng'],e.value);
		});

	$('.sliderDistance').addClass('hide');

	$('.btnFiltre')
		.mouseenter(function() {
    		$(this).find('img').toggleClass('hide');
    		$(this).addClass('survol');
		})
		.mouseleave(function() {
			if ($(this).hasClass('survol')){
				$(this).find('img').toggleClass('hide');
				$(this).parent().removeClass('survol');
			}
		});
		$('.btnFiltre').on('click',function(){
			$(this).parent().toggleClass('active');
			$(this).toggleClass('survol');

			if($(this).hasClass('btnStationService')){
				$('.stationEssence').toggleClass('hide');
			} else {
				$('.stationModulauto').addClass('hide');
				if($(this).parent().hasClass('active')){
					$('.siegeAuto').toggleClass('hide');
				} else {
					$('.stationModulauto').toggleClass('hide');
				}
				if ($('.infosVoiture').hasClass('active')){
					$('.infosVoiture.active').find('img').toggleClass('hide');
					$('.infosVoiture.active').removeClass('active');
				}
			}
		});
});

function initJQueryEventOnCarList(){

	$('.infosVoiture')
   		.on( "mouseenter", function() {
    		$(this).find('img').toggleClass('hide');
    		$(this).addClass('survol');
    		if($(this).find('.descVoiture').children().length == 0){
    			var idV = $(this).find('.btnVoiture').data('id');
	    		$.getJSON( "json/voitures.json", function( data ) {
	    			var infos = '';
					$.each( data, function( key, val ) {	
						if (val.id == idV) {
							infos += '<h5>' + val.nom + '</h5>';
							infos += '<p>' + val.categorie + '</p>';
						 	infos += '<ul>';
							    $.each( val.options.option, function( key, val ) {
									infos += '<li>' + val + '</li>';
								});
						 	infos += '</ul>';
						}
					});
					$('#descVoiture-'+idV).html(infos);
				});	
    		}			    		
			$(this).find('.dropdown-toggle').dropdown('toggle');
		})
		.on( "mouseleave", function() {
			if ($(this).hasClass('survol')){
				$(this).find('img').toggleClass('hide');
				$(this).parent().removeClass('survol');
			}
			$(this).find('.dropdown-toggle').dropdown('toggle');
		});

	$('.btnVoiture')
		.on( "click", function() {
			var liParent = $(this).parent().parent();
			var voitureId = $(this).data('id');
			if (!liParent.hasClass('active')){
				$('.listeVoiture').find('.active img').toggleClass('hide');
				$('.listeVoiture').find('.active').removeClass('active');
				$('.stationModulauto').removeClass('hide');
			}
			if ($('.btnSiegeAuto').parent().hasClass('active')){
				$('.btnSiegeAuto').find('img').toggleClass('hide');
				$('.btnSiegeAuto').parent().removeClass('active');
			}
			liParent.toggleClass('active');
			liParent.toggleClass('survol');
			$('.stationModulauto').toggleClass('hide');
			$('.voiture-'+voitureId).toggleClass('hide');
		});

}

