// JavaScript Document

/*
scrollers behaviour


*/

var JScrollers = new Class({

    getOptions: function(){
        return {
			showButtons:'yes',
			autoScroll:'no',
		    milliseconds: 5000
			
        };
    },
    initialize: function(dlist, options){
        this.setOptions(this.getOptions(), options);
		var ms = new String(MooTools.version);
		this.version = ms.substr(0,3);
        this.dlist = document.id(dlist);
		
		
		this.currDirection = 'forward';
				
		if ( this.dlist.hasClass('clickScroller') )
		{
		    this.inner = dlist.getFirst('div');
			this.outerSize = dlist.getSize();
		    this.innerSize = this.inner.getSize();
			this.boundary = 50;
			
            if(!this.outerSize.size)
			{
		        this.outerSize = {size:dlist.getSize()};
		        this.innerSize={scrollSize:this.inner.getScrollSize()};				
			}
		   //alert('out width=' + this.innerSize.size.x + ' inner height=' + this.innerSize.size.y);
		    //alert('outer width=' + this.outerSize.size.x + ' offset size=' + this.offsetWidth);
		    this.currLeft = 0;
		    this.currTop = 0;
			
			this.firstpane = this.inner.getFirst('div');
			if(this.firstpane)
			{
			   this.margin = this.firstpane.getStyle('margin').toInt();
			}
			this.direction = 'horizontal';
			if ( this.dlist.hasClass('vertical') )
			{
				this.direction = 'vertical';
			}

			if(this.options.showButtons == 'yes')
			{
				//this.forwardButton = new Element('div', {'html':'&nbsp;'}).injectAfter(this.dlist).addClass('forwardButton');
				this.forwardButton = new Element('div', {'html':'&nbsp;'}).addClass('forwardButton');
				this.forwardButton.inject(this.dlist,'after');
				this.forwardButton.setStyle('cursor', 'pointer');
				this.forwardButton.addClass(this.dlist.id + '_forward' );
				this.forwardButton.addClass(this.direction);
				if ( this.direction == 'horizontal')
				{			
				   this.forwardButton.addEvent('click', this.scrollForward.bind(this));
				}
				else
				{
				   this.forwardButton.addEvent('click', this.scrollDown.bind(this));
				}
				
				this.backButton = new Element('div',  {'html':'&nbsp;'}).addClass('backButton_disabled');
				this.backButton.inject(this.dlist,'before');
				this.backButton.setStyle('cursor', 'pointer');			
				this.backButton.addClass(this.dlist.id + '_back' );
				this.backButton.addClass(this.direction);	
				if ( this.direction == 'horizontal')
				{
					this.backButton.addEvent('click', this.scrollBack.bind(this));
				}
				else
				{
					this.backButton.addEvent('click', this.scrollUp.bind(this));
				}
			}
            this.scroller = new Fx.Scroll(this.dlist, {offset: { 'x': 0, 'y': 0 }});		
            this.dlist.addEvent('mouseover', this.stopScroll.bind(this));
            this.dlist.addEvent('mouseout', this.startScroll.bind(this));	
		    if(this.options.autoScroll == 'yes'){this.startScroll();}
		   
			
		}
		else
		{
           this.scroller = new Scroller(this.dlist, {area: 100, velocity: 1});
           this.dlist.addEvent('mouseover', this.scroller.start.bind(this.scroller));
           this.dlist.addEvent('mouseout', this.scroller.stop.bind(this.scroller));	
           this.dlist.setStyle('cursor', 'move');		   
		}
		
		
	},
	scrollForward : function(){
		if ( (this.currLeft + this.outerSize.size.x + this.boundary) < this.innerSize.scrollSize.x )
		{
			this.currLeft = this.currLeft + this.outerSize.size.x-this.margin;
			this.scroller.start( this.currLeft, this.currTop );
				
			
			if(this.backButton && this.backButton.hasClass('backButton_disabled'))
			{
				this.backButton.removeClass('backButton_disabled');
				this.backButton.addClass('backButton');
			}
			
			
		}
		
		if((this.innerSize.scrollSize.x - (this.currLeft + this.outerSize.size.x )) < this.boundary)
		{
		  this.currDirection = 'back';
		  if(this.forwardButton && this.forwardButton.hasClass('forwardButton'))
		  {
			  this.forwardButton.removeClass('forwardButton');
		      this.forwardButton.addClass('forwardButton_disabled');
		  }
		}
		//alert('inner scroll left=' + this.currLeft + ' inner scroll height=' + this.currTop);	
		
	},
	scrollBack : function(){
		
		if ( (this.currLeft - this.outerSize.size.x ) > 0 )
		{
			this.currLeft = this.currLeft - this.outerSize.size.x+this.margin;
			
		}
		else
		{
		  this.currLeft = 0;	
		  this.currDirection = 'forward';
		  if(this.backButton && this.backButton.hasClass('backButton'))
		  {
			  this.backButton.removeClass('backButton');
		      this.backButton.addClass('backButton_disabled');
		  }
		  
		  
		}
		
		if(this.forwardButton && this.forwardButton.hasClass('forwardButton_disabled'))
		{
			this.forwardButton.removeClass('forwardButton_disabled');
			this.forwardButton.addClass('forwardButton');
		}
		
		
		this.scroller.start( this.currLeft, this.currTop );
		
		
		
	},
	scrollDown : function(){
		
		if ( (this.currTop + this.outerSize.size.y + this.boundary) < this.innerSize.scrollSize.y )
		{
			this.currTop = this.currTop + this.outerSize.size.y - this.margin;
			this.scroller.start( this.currLeft, this.currTop );
			
			if(this.backButton && this.backButton.hasClass('backButton_disabled'))
			{
				this.backButton.removeClass('backButton_disabled');
				this.backButton.addClass('backButton');
			}
			
			
		}
		
		if ( ( this.innerSize.scrollSize.y - (this.currTop + this.outerSize.size.y)) < this.boundary )
		{
		  this.currDirection = 'back';
		  if(this.forwardButton && this.forwardButton.hasClass('forwardButton'))
		  {
			  this.forwardButton.removeClass('forwardButton');
		      this.forwardButton.addClass('forwardButton_disabled');
		  }
		  
		}
		//alert('inner scroll left=' + this.currLeft + ' inner scroll height=' + this.currTop);	
		
	},
	scrollUp : function(){
		
		if ( (this.currTop - this.outerSize.size.y) > 0 )
		{
			this.currTop = this.currTop - this.outerSize.size.y + this.margin;
			
		}
		else
		{
			this.currTop = 0;
			this.currDirection = 'forward';
			if(this.backButton && this.backButton.hasClass('backButton'))
			{
				this.backButton.removeClass('backButton');
				this.backButton.addClass('backButton_disabled');
			}
			
		}
		
		if(this.forwardButton && this.forwardButton.hasClass('forwardButton_disabled'))
		{
			this.forwardButton.removeClass('forwardButton_disabled');
			this.forwardButton.addClass('forwardButton');
		}
		
		
		this.scroller.start( this.currLeft, this.currTop );
	
		
		
	},
	startScroll: function(){	
	  if(this.options.autoScroll == 'yes')
	  {
	     this.intervalID = this.nextSlide.periodical( this.options.milliseconds, this );
	  }
	},
	stopScroll: function(){
      if(this.options.autoScroll == 'yes')		
	  {
		this.intervalID = clearInterval( this.intervalID );
	  }
	},
	nextSlide: function()
	{
		if(this.currDirection == 'forward')
		{
		   if(this.direction == 'horizontal')
		   {
			   this.scrollForward();
		   }
		   else
		   {
			   this.scrollDown();   
		   }
		}
		else
		{
		   if(this.direction == 'horizontal')
		   {
			   this.scrollBack();
		   }
		   else
		   {
			   this.scrollUp();   
		   }			
		}
	}

});

JScrollers.implement(new Events);
JScrollers.implement(new Options);

//alert('scrollpane included');

