<?php
/**
*
* @copyright	Inspiration Web Design
* License GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

require_once (JPATH_SITE.'/components/com_content/helpers/route.php');


class modFeaturedItemsCarouselJ25ContentHelper
{
  /* helper class for Joomla Core Content */
  
	
	
	public static function getList(&$params)
	{
	  //returns object list
			

		$db			= JFactory::getDBO();
		$user		= JFactory::getUser();
		$userId		= (int) $user->get('id');

		$count		= (int) $params->get('count', 10);
		
	   $catParam = $params->get('catid');
	   $catid = '';
	   
		if(is_array($catParam))
		{
			if(! in_array('0',$catParam))
			{
		       $catid	= implode(',', $catParam );
				
			}
		}
		else
		{
			if($catParam != '0') //0 is the root category
			{
		       $catid = trim($catParam);
			}
		}		
		
		if(is_array($params->get('articleid')))
		{
		    $articleid		= implode(',', $params->get('articleid') );
		}
		else
		{
		    $articleid	= trim( $params->get('articleid') );	
		}
		$show_featured	= $params->get('show_front', 1);
		$show_images= $params->get('show_images', 1);
		$align_images= $params->get('align_images', 'left');
		$use_gd      = $params->get('use_gd', 'no'); 
		$readmore    = $params->get('read_more','yes');
        $link_images = $params->get('link_images','yes');		  
		
		$aid		= $user->get('aid', 0);
		$count_chars      = $params->get('count_chars', 'yes');   
		$textcount	= (int) $params->get('textcount', 50);	
		$sentencecount	= (int) $params->get('sentencecount', 1);			
		$maxsize	= (int) $params->get('maximagesize', 100);		

		$contentConfig = JComponentHelper::getParams( 'com_content' );
		$access		= !$contentConfig->get('shownoauth');

		$nullDate	= $db->getNullDate();
		$dateFormat = $db->getDateFormat();
		$date = JFactory::getDate();
		$now = $date->format($date);
		
	    $jinput = JFactory::getApplication()->input;	  

		$option = $jinput->get('option','','cmd');
		$view = $jinput->get('view','','cmd');
		$task = $jinput->get('task','','cmd');		
		
		$profileId = (int) $jinput->get('userid','0','int');
		if($profileId == 0){ $profileId = (int) $jinput->get('user_id','0','int'); }
		if($profileId == 0){ $profileId = (int) $jinput->get('user','0','int'); }
		if(($profileId == 0) && ($option=='com_k2') && ($task=='user')){ $profileId = (int) $jinput->get('id','0'); }

        //get published filter
		$where		= 'a.state = 1'
			. ' AND ( a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' )'
			. ' AND ( a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )'
			;
		

		// User Filter
		switch ($params->get( 'user_id' ))
		{
			case 'by_me':
				$where .= ' AND (created_by = ' . (int) $userId . ' OR modified_by = ' . (int) $userId . ')';
				break;
			case 'not_me':
				$where .= ' AND (created_by <> ' . (int) $userId . ' AND modified_by <> ' . (int) $userId . ')';
				break;
		}
		
		$groups	= implode(',', $user->getAuthorisedViewLevels());
		
		if($access)
		{
	        $where .= ' AND (cc.access IN ('.$groups.')) ';
	        $where .= ' AND (a.access IN ('.$groups.')) ';
			
		}
		
		
		$featuredCondition = '';
		switch ($show_featured)
		{
		   case '0': $featuredCondition = 	' AND a.featured = 0 ';
		           break;
		   case '2': $featuredCondition = ' AND a.featured = 1 ';
		           break;
	
			
		}
		
				
		
		if(($params->get( 'user_id' ) == 'profile') && ($option == "com_community") && ($view == 'profile'))
		{
			$where .= ' AND (created_by = ' . (int) $profileId . ' OR modified_by = ' . (int) $profileId . ')';
		}
		else if(($params->get( 'user_id' ) == 'profile') && ($option == "com_comprofiler") && ($task == 'userProfile'))
		{
			//community builder
			$where .= ' AND (created_by = ' . (int) $profileId . ' OR modified_by = ' . (int) $profileId . ')';
			
		}
		else if(($params->get( 'user_id' ) == 'profile') && ($option == "com_k2") && ($task == 'user'))
		{
			//k2
			$where .= ' AND (created_by = ' . (int) $profileId . ' OR modified_by = ' . (int) $profileId . ')';
			
		}
		

		
        //get filters for all sections, categories, authors list 
		
		
		
		$catCondition = '';
		$artCondition = '';
        //get filters for all list types
		if ($catid)
		{
			$ids = explode( ',', $catid );
			JArrayHelper::toInteger( $ids );
			$catCondition = ' AND (cc.id=' . implode( ' OR cc.id=', $ids ) . ') ';
		}
		if ($articleid)
		{
			$ids = explode( ',', $articleid );
			JArrayHelper::toInteger( $ids );
			$artCondition = ' AND (a.id=' . implode( ' OR a.id=', $ids ) . ') ';
		}
		
		
	   if( $params->get('use_request','no') == 'yes')
	   {
		   //use request value instead if this is set and the user request parameter is true
		    $option = $jinput->get('option','','cmd');

	      	if (($jinput->get('view') == 'category') && ($option == 'com_content')) {
			  $id = intval($jinput->get('id','','int'));
			  $catCondition = ' AND (cc.id='.strval($id).') ';
			  
			}
	      	else if (($jinput->get('view') == 'article') && ($option == 'com_content')) {
			  $id = intval($jinput->get('catid','','int'));
			  if($id > 0)
			  {
			     $catCondition = ' AND (cc.id='.strval($id).') ';
			  }
				
			}
	   }						
		
		// Ordering
		switch ($params->get( 'ordering' ))
		{
		    case 'title': $ordering = 'a.title ASC';
			              break;				
		    case 'h_dsc': $ordering = 'a.hits DESC';
			              break; 
			case 'h_asc': $ordering = 'a.hits ASC';
			              break;
            case 'o_asc': $ordering = 'a.ordering ASC';
			              break;						  
			case 'm_dsc': $ordering = 'a.modified DESC, a.created DESC';
				          break;
			case 'random': $ordering = 'RAND()';
			          break;						  
			case 'c_dsc':
			case 'list':									
			default:  $ordering = 'a.created DESC';
				      break;
		}		
		

		$where = $where.$catCondition.$artCondition.$featuredCondition.' AND cc.published = 1';
		
		$query = $db->getQuery(true);

		// Content Items only
		$query->select('a.*,  u.name AS name');
	    $query->from('#__content AS a');
		$query->innerJoin('#__categories AS cc ON cc.id = a.catid');
		$query->innerJoin('#__users AS u ON u.id = a.created_by');
	    $query->where($where);
		$query->order($ordering);
		    
		$db->setQuery($query, 0, $count);
		$rows = $db->loadObjectList();
		
		
		if((!empty($articleid)) && ($params->get('ordering')=='list'))
		{
		   $ids = explode( ',', $articleid );
		   JArrayHelper::toInteger( $ids );
		   
		   $listRows = array();
		   
		   foreach ($ids as $id)
		   {
		     foreach ($rows as $row)
		     {
               if( $row->id == $id)
			   {
			     $listRows[] = $row;
			   }
		     }
		   }
		   $rows = $listRows;				
		}		
		
	    return $rows;
	}
	
	public static function getImageTag(&$params, &$row, $title = '')
	{
		
		$show_images= $params->get('show_images', '1');
		$align_images= $params->get('align_images', 'left');
		$use_gd      = $params->get('use_gd', 'no'); 
		$maxsize	= (int) $params->get('maximagesize', 100);	
		$maximagetype = $params->get('maximagetype','both');	
		
	    $filterTags = array();
	    $filterAttrs = array();
		$filter	= new JFilterInput( $filterTags, $filterAttrs, 0, 0 );
		
		
		$imageTag = '';
		if($show_images == '0')
		{
		  return $imageTag;	
		}
		
		$size = FALSE;
		$imageURL = '';
	    $imageFound = false;		
			
			if (preg_match('/<!--image:(.*?)-->/',$row->introtext, $matches))
			{
			  $imageURL = $filter->clean( $matches[1], 'PATH' );
		      $imageFound = true;			  
			  $altText = '';
			  if (preg_match('/<!--alt:(.*?)-->/',$row->introtext, $matches))
              $altText = $filter->clean( $matches[1] );
			  
				 
		    }	//end if preg_match	
			else if(isset($row->images) && !empty($row->images))
			{
				$imageInfo = json_decode($row->images);
				if(isset($imageInfo->image_intro) && !empty($imageInfo->image_intro))
				{
					$imageURL = $imageInfo->image_intro;
					$altText = $imageInfo->image_intro_alt;
					$titleText = $imageInfo->image_intro_caption;
			        $imageFound = true;					
				}
			}
			
			
			
            if (!$imageFound &&  preg_match('/<img[^>]*>/i', $row->introtext, $matches ) == 1)
			{
			   $imageTag = $matches[0];
			   $altText = '';
			   $titleText = '';

			  if (preg_match('/alt=[\'"]([^\'"]*)[\'"]/i', $imageTag, $altmatches ) == 1)
			  {
			     $altText = $altmatches[1];
			  } 
			  
			  if (preg_match('/title=[\'"]([^\'"]*)[\'"]/i', $imageTag, $titlematches ) == 1)
			  {
			     $titleText = $titlematches[1];
			  } 			  
			   
			  if (preg_match('/src=[\'"]([^\'"]*)[\'"]/i', $imageTag, $morematches ) == 1)
			  {
			     $imageURL = $morematches[1];
				 
			   }
			 }

			if( $imageURL != '')
			{

			   $liveSite 	= JURI::base();
			   $imageURL = str_replace( $liveSite, '', $imageURL );
			   
			   
			   $imagePath = str_replace( JPATH_BASE, '', $imageURL);
			   $imagePath = str_replace('\\','/',$imagePath);
			   
			   //$imagePath = JPATH_BASE.DS.$imagePath;
				   
				   
			   $size = @getimagesize(rawurldecode($imagePath));
			}
			else
			{
			 return $imageTag;	
			}

			 if ( $size )
			 {
				$width = $size[0];
				$height = $size[1];

				  if($maximagetype == 'both'){
					  
					  if (($width > $height) && ($width > $maxsize ))
					  {
						$ratio = $maxsize/$width;
						$newwidth = $maxsize;
						$newheight = intval($height * $ratio);
					  }
					  else if (($width <= $height) && ($height > $maxsize))
					  {
						$ratio = $maxsize/$height;
						$newheight = $maxsize;
						$newwidth = intval($width * $ratio);
					  }
					  else
					  {
						$newwidth = $width;
						$newheight = $height;
					  }
				  }
				  else 	if($maximagetype == 'width'){
					  if ($width > $maxsize )
					  {
						$ratio = $maxsize/$width;
						$newwidth = $maxsize;
						$newheight = intval($height * $ratio);
					  }
					  else
					  {
						$newwidth = $width;
						$newheight = $height;
					  }					  					  
				  }
				  else { //use height
				  
					 if ($height > $maxsize)
					 {					  
						$ratio = $maxsize/$height;
						$newheight = $maxsize;
						$newwidth = intval($width * $ratio);
					 }
					  else
					  {
						$newwidth = $width;
						$newheight = $height;
					  }					  					  						 					  
				  }
				  
				  if ( $use_gd == 'yes' ){
					 $imageURL = 'modules/mod_featureditems_carousel/assets/resize.php?img=' . rawurlencode($imageURL ) . '&amp;width=' . $newwidth . '&amp;height=' .$newheight;
				  
				  }
			      $imageTag = '<img  src="' . $imageURL . '" width="' . $newwidth. 'px" height="' . $newheight . 'px" alt="' . $altText . '" title="' . $title . '" style="float:' . $align_images .'" class="featureditemscarousel_image"/>';
				  
				  
			 
			 }//end if ( $size )
			 else  
			 {
				 //can't resize image file, usually because the image file path is incorrect, so let browser do this
				 
				 if(($maximagetype == 'width') || ($maximagetype == 'both'))
				 {
			          $imageTag = '<img  src="' . $imageURL . '" width="' . $maxsize. 'px" alt="' . $altText . '" title="' . $title . '" style="float:' . $align_images .'" class="featureditemscarousel_image"/>';
					 
					 
				 }
				 else
				 {
			          $imageTag = '<img  src="' . $imageURL . '" height="' . $maxsize. 'px" alt="' . $altText . '" title="' . $title . '" style="float:' . $align_images .'" class="featureditemscarousel_image"/>';
				 }
				 
			 }
		     
			 return $imageTag;
		
	}//end get image tag
	
	public static function getLink(&$params, &$row)
	{
	   $link = ContentHelperRoute::getArticleRoute($row->id, $row->catid);
	   return $link;
	
	}
	



}