<?php
/**
*
* @copyright	Inspiration Web Design
* License GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');
jimport('joomla.html.html');


//require_once (dirname(__FILE__).DS.'classes'.DS.'scrollpane.php');
require_once (dirname(__FILE__).'/includes/modFeaturedItemsCarouselContentHelper.php');			

class modFeaturedItemsCarouselHelper
{
    public static function getLayout(&$params)
	{
		JHTML::_('behavior.framework',true);		
		JHTML::addIncludePath(JPATH_SITE.'/modules/mod_featureditems_carousel/classes/');
		$layout = new stdClass();
        $layout->id = 'pane' . '_' . uniqid('feat');
	   	$layout->name     = $params->get('layout', 'default');	
		$layout->direction = $params->get('direction', 'horizontal');
		$layout->event = $params->get('scrollevent', 'clickScroller');
        $count		= (int) $params->get('count', 10);
        $visiblecount = (int) $params->get('visiblecount', 5);
		
		//is caching enabled?
		//$config = JFactory::getConfig();
		//$caching = $config->getValue('config.caching');
		$caching = false;
		$layout->scripts = '';
		$layout->stylesheets = '';
		$layout->colour = $params->get('color_scheme', 'silver');

		
		$doc = JFactory::getDocument();
		if(!$caching)
		{
		    $doc->addStyleSheet( 'modules/mod_featureditems_carousel/css/colors/' . $params->get('color_scheme', 'silver').'.css' );
		}
		else
		{
			$layout->stylesheets =  $layout->stylesheets. '<link rel="stylesheet" href="'.JURI::root(true).'/'.'modules/mod_featureditems_carousel/css/colors/'.$params->get('color_scheme', 'silver').'.css" type="text/css"/> ';
		}
		
		$fixedwidth = $params->get('fixedwidth', '');
		$fixedheight = $params->get('fixedheight', '');
		$style = '';
		if ( $fixedwidth != '' )
		{ 
		  $intfixedwidth = intval($fixedwidth);
		  if ( $intfixedwidth > 0 )
		  {
		    $style .= 'width:' . strval($intfixedwidth) . 'px;';
		  }
		}
		
		if ( $fixedheight != '' )
		{ 
		  $intfixedheight = intval($fixedheight);
		  if ( $intfixedheight > 0 )
		  {
		    $style .= 'height:' . strval($intfixedheight) . 'px;';
		  }
		}		
		$layout->style = $style;	
		
		$layout->itemwidth = intval($params->get('itemwidth', '160'));
		$layout->itemheight = intval($params->get('itemheight', '120'));
		$layout->itemmargin = intval($params->get('itemmargin', '4'));
		$style = '';
		
		$style .= 'div.carousel_outer{ overflow:hidden; cursor:default; } ';	
		
		
	     if ( $layout->direction == 'horizontal' )
		 {
			$style = $style . 'div#' . $layout->id . '_inner div.scrollpanel{ width:' . strval($layout->itemwidth) . 'px; height:' . strval($layout->itemheight) .'px; float:left; margin:'. strval($layout->itemmargin) . 'px; overflow:hidden; position:relative;} ';
			$style = $style . 'div#' . $layout->id . '_outer{ width:' . strval(($layout->itemwidth + $layout->itemmargin*2) * $visiblecount + $layout->itemmargin) .'px; height:' . strval($layout->itemheight+$layout->itemmargin*2) .'px; float:left; position:relative;} ';
			$style = $style . 'div#' . $layout->id . '_inner{ width:' . strval(($layout->itemwidth + $layout->itemmargin*2 )* $count + $layout->itemmargin) .'px; height:' . strval($layout->itemheight) .'px; position:relative;} ';
			$style = $style.'div.' . $layout->id . '_outer_forward, div.' . $layout->id . '_outer_back{ height:' . strval($layout->itemheight+$layout->itemmargin*2) .'px; width: 20px; float:left;} ';
			$style = $style . 'div#' . $layout->id . '{ width:' . strval(($layout->itemwidth + $layout->itemmargin*2) * $visiblecount + $layout->itemmargin+ 40) .'px; height:' . strval($layout->itemheight+$layout->itemmargin*2) .'px;  float:left; position:relative;} ';
			
			
		} 
		else 
		{
			$style = $style . 'div#' . $layout->id . '_inner div.scrollpanel{ width:' . strval($layout->itemwidth) . 'px; height:' . strval($layout->itemheight) .'px;  margin:'. strval($layout->itemmargin) . 'px; overflow:hidden;} ';
			$style = $style . 'div#' . $layout->id . '_outer{ width:' . strval($layout->itemwidth + $layout->itemmargin*2+2) .'px; height:' . strval(($layout->itemheight + $layout->itemmargin) * $visiblecount + $layout->itemmargin) .'px; } ';
			$style = $style . 'div#' . $layout->id . '_inner{ width:' . strval($layout->itemwidth + $layout->itemmargin*2) .'px; height:' . strval(($layout->itemheight + $layout->itemmargin * 2) * $count + $layout->itemmargin) .'px;} ';
			$style = $style . 'div.' . $layout->id . '_outer_forward, div.' . $layout->id . '_outer_back{ width:' . strval($layout->itemwidth + $layout->itemmargin*2+2) .'px; height:12px; } '; 
			$style = $style . 'div#' . $layout->id . '{ width:' . strval($layout->itemwidth + $layout->itemmargin*2+10) .'px; height:' . strval(($layout->itemheight + $layout->itemmargin*2) * $visiblecount + $layout->itemmargin + 40) .'px; overflow:hidden;} ';
			
		}
		
		if(! $caching)
		{
            $doc->addStyleDeclaration($style);			
		}
		else
		{
		    $layout->stylesheets = $layout->stylesheets .' <style type="text/css">'.$style.'</style> ';	
		}
		
		  if(!$caching)
		  {
             $doc->addStyleSheet( 'modules/mod_featureditems_carousel/css/layouts/'.$params->get('layout','default' ).'.css');
		  }
		  else
		  {
			  $layout->stylesheets  = $layout->stylesheets. '<link rel="stylesheet" type="text/css" href="'.JURI::root(true).'/'.'modules/mod_featureditems_carousel/css/layouts/'.$params->get('layout','default' ).'.css" /> ';
		  }
		  
		$milliseconds = (int)$params->get('scrollerSpeed','10')*1000;
        $paramArray = 	array('scrollEvent'=>$layout->event, 'scrollDirection'=>$layout->direction,'autoScroll'=>$params->get('autoScroll','no'),'showButtons'=>$params->get('showButtons','yes'),'milliseconds'=>$milliseconds);	
		if($layout->name == 'thumbnails-with-slide'){
			$paramArray['imageSliders'] = true;
			$paramArray['imageTransition'] = $params->get('sliderEffect','horizontal-slide');
		}
        $layout->paramArray = $paramArray;

		
		//$layout->pane = JPane::getInstance('scrollers', $paramArray);
				
		return $layout;
	}
	
	public static function getList(&$params)
	{
		$rows = array();
		$lists = array();
		
		modFeaturedItemsCarouselContentHelper::getHelper($params); //loads the correct helper - important!
		$rows = modFeaturedItemsCarouselContentHelper::getList($params);
		if(count($rows)>0)
		{
		  $lists = modFeaturedItemsCarouselHelper::parseResult($params, $rows);
		}


		return $lists;
	}
	
	
	public static function parseResult(&$params, &$rows)
	{
		$readmore    = $params->get('read_more','yes');
        $link_images = $params->get('link_images','yes');		  
		
		$count_chars      = $params->get('count_chars', 'yes');   
		$textcount	= (int) $params->get('textcount', 50);	
		$sentencecount	= (int) $params->get('sentencecount', 1);			
		$menuitemid = trim($params->get('menuitemid',''));
		
		$i		= 0;
		$lists	= array();
		
		foreach ( $rows as $row )
		{
			$lists[$i] = new stdClass();
		    $lists[$i]->author = '';
			$lists[$i]->html = '';
			$lists[$i]->imageTag = '';
			$lists[$i]->comment = '';
			$lists[$i]->text = '';
			$lists[$i]->readmore = '';
		 
		    $link =  modFeaturedItemsCarouselContentHelper::getLink($params, $row);
		    $currid = JRequest::getVar('Itemid','');
		   
			if(($menuitemid != '') && (strpos($link,'Itemid=') === FALSE))
			{
			  $link .= '&amp;Itemid='.$menuitemid;
			}
			/*else if(($currid != '') && (strpos($link,'Itemid=') === FALSE))
			{ //use current Itemid if not set
			  $link .= '&amp;Itemid='.$currid;
			}*/



			$lists[$i]->link = JRoute::_($link);
			$lists[$i]->heading = $row->title;	
			
			if ( $readmore == 'yes' )
			{		
			   $lists[$i]->readmore = ' <a href="' . $lists[$i]->link .'" class="featureditems_readmore' . $params->get('moduleclass_sfx') . '">'.$params->get('read_more_text','Read more...').'</a>';
			}
			
			
			/*get text*/
			if ( $count_chars == 'yes')
			{
				if ($textcount == 0)
				{
				  $itemtext = '';
				}
				else
				{
				   $itemtext = strip_tags( $row->introtext, '<br>' );
				   if($params->get('triggerPlugin','no') == 'no')
				   {
				      $itemtext = preg_replace('/\{[^}]*\}/','', $itemtext);	
				   }
				}
				
				if ( $textcount >= strlen( $itemtext ) )
				{
				  $lists[$i]->text = $itemtext;
				}
				else
				{
				   $pos = strpos( $itemtext, ' ', $textcount );
				   if ( $pos === false)
				   {
					  $lists[$i]->text = $itemtext . '...';			   
				   }
				   else
				   {
					  $lists[$i]->text = substr( $itemtext, 0, $pos ) . '...';
				   }
				}
			}
			else if( $count_chars == 'no')/* count sentences */
			{
			    $lists[$i]->text = '';
				if ($sentencecount > 0)
                {
				   $itemtext = strip_tags( $row->introtext,'<br>' );
				   if($params->get('triggerPlugin','no') == 'no')
				   {				   
				       $itemtext = preg_replace('/\{[^}]*\}/','', $itemtext);	
				   }
				   $sentence_array = preg_split( '/([^A-Z]\.|[!?])/',$itemtext, -1, PREG_SPLIT_DELIM_CAPTURE);
				   $sentences = array(); 
				   //print_r($sentence_array);
				  
				   if(!isset($sentence_array[1]))
				   {
					 $lists[$i]->text = $itemtext; 
				   }
				   else
				   {
					 for (  $j=0; $j<(count( $sentence_array )-1); $j+=2)
					 {
					   $sentences[] = $sentence_array[$j].$sentence_array[$j+1];
					 }
					 $scount = 0;
					 foreach ( $sentences as $s ){
					   $lists[$i]->text .= $s;				  
					   $scount++;
					   if ( $scount >= $sentencecount ) { break; }
					 }
				   }
				}//end if sentencecount>0
			}//end count sentence			
			else //use entire text
			{
			   $itemtext = $row->introtext;
			   if($params->get('triggerPlugin','no') == 'no')
			   {				   
				   $itemtext = preg_replace('/\{[^}]*\}/','', $itemtext);	
			   }
			   $itemtext = preg_replace('/<img[^>]*>/i','',$itemtext); //remove image tags, because thumbnail will be generated.
			   $lists[$i]->text = $itemtext;
			}
			if($params->get('triggerPlugin','no') == 'yes')
			{
			    $lists[$i]->text = JHTML::_('content.prepare', $lists[$i]->text);
				
			}
			
			if($params->get('showAuthor','no') == 'yes')
			{
      			$lists[$i]->author = JText::_('WRITTENBY').' '.$row->name;
			}
			else
			{
      			$lists[$i]->author = '';				
			}
			
			if( ! empty($row->created) && ($params->get('showCreated','no') == 'yes'))
			{
			
			   $created = new JDate($row->created);
			   
			   $lists[$i]->created =  JText::_('CREATED').' '.$created->toFormat($params->get('dateFormat','%a, %d %b %Y %H:%M'));
			}
			else
			{
			  $lists[$i]->created = '';
			}
			
			if( ! empty($row->modified) && ($params->get('showModified','no') == 'yes'))
			{
			   if($row->modified == '0000-00-00 00:00:00')
			   {
			        $modified = new JDate($row->created);
				   
			   }
			   else
			   {
			       $modified = new JDate($row->modified);
			   }
			   $lists[$i]->modified =  JText::_('LASTUPDATED').' '.$modified->toFormat($params->get('dateFormat','%a, %d %b %Y %H:%M'));
			}
			else
			{
			  $lists[$i]->modified = '';
			}
			

			
			
			$filterTags = array('a','p','h2','h3','h5','h6','span','pre','img');
			$filterAttrs = array('class','width','height','title','href','src');
			$filter	= new JFilterInput( $filterTags, $filterAttrs, 0, 0 );
			
			/*now deal with synopsis etc*/
			
			if (preg_match('/<!--synopsis:(.*?)-->/',$row->introtext, $matches))
			{
			  $lists[$i]->text = $filter->clean( $matches[1] );
			}

			
			if (preg_match('/<!--comment:(.*?)-->/',$row->introtext, $matches))
			{
			  $lists[$i]->comment = '<span class="featured_comment">'.$filter->clean( $matches[1] ).'</span>';
			}
			
									
			/*get image*/
			$lists[$i]->imageTag = modFeaturedItemsCarouselContentHelper::getImageTag($params, $row, $lists[$i]->heading);
		    if ( ($link_images == 'yes' ) && ($lists[$i]->imageTag != ''))
			{
					$lists[$i]->imageTag = '<a href="' . $lists[$i]->link .'">'. $lists[$i]->imageTag . '</a>';					  
			}

			$i++;
		}
		return $lists;
	}
}
